/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.core.v2_1.graphics;

import com.roguewave.chart.core.v2_1.graphics.ClickableDrawable;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.Line3D;
import com.roguewave.chart.core.v2_1.graphics.Line3DDrawable;
import com.roguewave.chart.core.v2_1.graphics.Markings3DDrawable;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Polygon3D;
import com.roguewave.chart.core.v2_1.graphics.Polygon3DDrawable;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class Canvas3D
extends Canvas
implements MouseListener {
    double rotation_;
    double tilt_;
    double distance_;
    Transform3D s;
    Transform3D per;
    int w_;
    int h_;
    Vector clickables_;
    double sx2D_ = 50.0;
    double sy2D_ = 50.0;
    int panX_;
    int panY_;
    double perDistance_ = 2.0;
    double shearFactor_;
    double shearX_ = this.shearFactor_ = 0.2;
    double shearY_ = this.shearFactor_;
    int border3D_;
    Dimension preferredSize_ = new Dimension(300, 250);
    boolean aspectPreservation_ = true;
    double aspect_;
    double sWidth_;
    double sHeight_;
    private transient Drawable[] drawables_;
    private transient int drawCount_;
    private transient int drawMax_ = 2500;

    public Canvas3D() {
        this.setView(0.0, 0.0, 3.0);
        this.w_ = this.getSize().width;
        this.h_ = this.getSize().height;
        this.aspect_ = (double)this.w_ / (double)this.h_;
        this.sWidth_ = (double)this.w_ / this.sx2D_;
        this.sHeight_ = (double)this.h_ / this.sy2D_;
        this.drawCount_ = 0;
        this.drawMax_ = 2500;
        this.drawables_ = new Drawable[this.drawMax_];
        int n = 0;
        while (n < this.drawMax_) {
            this.drawables_[n] = null;
            ++n;
        }
        this.clickables_ = new Vector();
        this.addMouseListener(this);
    }

    public void setPerspective() {
        this.per = Transform3D.perspective(this.perDistance_);
    }

    public void setPerspective(double d) {
        this.perDistance_ = d;
        this.per = Transform3D.perspective(d);
    }

    public void setShear() {
        this.per = Transform3D.shear(this.shearFactor_);
    }

    public void setShear(double d) {
        this.shearX_ = this.shearY_ = d;
        this.shearFactor_ = this.shearY_;
        this.per = Transform3D.shear(this.shearFactor_);
    }

    public void setShear(double d, double d2) {
        this.shearX_ = d;
        this.shearY_ = d2;
        this.per = Transform3D.shear(d, d2);
    }

    public double getShearX() {
        return this.shearX_;
    }

    public double getShearY() {
        return this.shearY_;
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setSize(int n, int n2) {
        this.handleResize(n, n2);
        super.setSize(n, n2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.handleResize(n3, n4);
    }

    private void handleResize(int n, int n2) {
        this.w_ = n;
        this.h_ = n2;
        this.aspect_ = (double)this.w_ / (double)this.h_;
        this.sWidth_ = (double)this.w_ / this.sx2D_;
        this.sHeight_ = (double)this.h_ / this.sy2D_;
        this.preferredSize_ = new Dimension(n, n2);
    }

    public void setView(double d, double d2, double d3) {
        this.rotation_ = d;
        this.tilt_ = d2;
        this.distance_ = d3;
        this.setView();
    }

    private void setView() {
        Transform3D transform3D = Transform3D.product(Transform3D.rotateX(-this.tilt_), Transform3D.rotateY(this.rotation_));
        this.s = Transform3D.product(Transform3D.translate(0.0, 0.0, this.distance_), transform3D);
        this.per = Transform3D.perspective(this.perDistance_);
    }

    public double getRotation() {
        return this.rotation_;
    }

    public void setRotation(double d) {
        this.rotation_ = d;
        this.setView();
    }

    public double getTilt() {
        return this.tilt_;
    }

    public void setTilt(double d) {
        this.tilt_ = d;
        this.setView();
    }

    public double getViewDistance() {
        return this.distance_;
    }

    public void setViewDistance(double d) {
        this.distance_ = d;
        this.setView();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        ClickableDrawable clickableDrawable = null;
        int n3 = 0;
        while (n3 < this.clickables_.size()) {
            ClickableDrawable clickableDrawable2 = (ClickableDrawable)this.drawables_[(Integer)this.clickables_.elementAt(n3)];
            if (clickableDrawable2.isOn(this, n, n2)) {
                clickableDrawable = clickableDrawable2;
            }
            ++n3;
        }
        if (clickableDrawable != null) {
            clickableDrawable.clicked(n, n2);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public synchronized void addClickable(ClickableDrawable clickableDrawable) {
        this.clickables_.addElement(new Integer(this.drawCount_));
        this.addDrawable(clickableDrawable);
    }

    public synchronized void addDrawable(Drawable drawable) {
        if (this.drawables_ == null || this.drawables_.length == 0) {
            this.drawMax_ = 2500;
            this.drawables_ = new Drawable[this.drawMax_];
            int n = 0;
            while (n < this.drawMax_) {
                this.drawables_[n] = null;
                ++n;
            }
            this.drawCount_ = 0;
        }
        if (this.drawCount_ >= this.drawMax_) {
            Drawable[] drawableArray = this.drawables_;
            this.drawMax_ *= 2;
            this.drawables_ = new Drawable[this.drawMax_];
            int n = 0;
            while (n < this.drawCount_) {
                this.drawables_[n] = drawableArray[n];
                ++n;
            }
            int n2 = this.drawCount_;
            while (n2 < this.drawMax_) {
                this.drawables_[n2] = null;
                ++n2;
            }
        }
        this.drawables_[this.drawCount_++] = drawable;
    }

    public void addLine(Line3D line3D, Color color) {
        this.addDrawable(new Line3DDrawable(line3D, color));
    }

    public void addMarkings(Markings3DDrawable markings3DDrawable) {
        this.addDrawable(markings3DDrawable);
    }

    public void addPolygon(Polygon3D polygon3D) {
        this.addDrawable(new Polygon3DDrawable(polygon3D));
    }

    public boolean backFacing(Point3D[] point3DArray) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        int n = 0;
        while (n < 3) {
            Point3D point3D = this.per.transform(this.s.transform(point3DArray[n]));
            dArray[n] = point3D.X();
            dArray2[n] = point3D.Y();
            ++n;
        }
        boolean bl = (dArray2[1] - dArray2[0]) * (dArray[2] - dArray[1]) - (dArray[1] - dArray[0]) * (dArray2[2] - dArray2[1]) < 0.0;
        return bl;
    }

    public synchronized void clear() {
        int n = 0;
        while (n < this.drawCount_) {
            this.drawables_[n] = null;
            ++n;
        }
        this.drawCount_ = 0;
        this.clickables_ = new Vector();
    }

    public void drawLine(Line3D line3D, Graphics graphics, Color color) {
        Point3D point3D = this.per.transform(this.s.transform(line3D.end1()));
        Point3D point3D2 = this.per.transform(this.s.transform(line3D.end2()));
        graphics.setColor(color);
        graphics.drawLine((int)((double)(this.w_ / 2 + this.panX_) + point3D.X() * this.sx2D_ + 0.5), (int)((double)(this.h_ / 2 - this.panY_) - point3D.Y() * this.sy2D_ + 0.5), (int)((double)(this.w_ / 2 + this.panX_) + point3D2.X() * this.sx2D_ + 0.5), (int)((double)(this.h_ / 2 - this.panY_) - point3D2.Y() * this.sy2D_ + 0.5));
    }

    public void drawPolygon(Polygon3D polygon3D, Transform3D transform3D, Graphics graphics) {
        Transform3D transform3D2 = this.s;
        this.s = new Transform3D(this.s, transform3D);
        this.drawPolygon(polygon3D, graphics);
        this.s = transform3D2;
    }

    private Polygon makeAWTPolygon(Polygon3D polygon3D) {
        Polygon polygon = new Polygon();
        int n = polygon3D.sides();
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        int n2 = 0;
        while (n2 <= n) {
            Point3D point3D = this.per.transform(this.s.transform(polygon3D.getPoint(n2 % n)));
            if (n2 < 3) {
                double d;
                dArray[n2] = point3D.X();
                dArray2[n2] = point3D.Y();
                if (n2 == 2 && (d = (dArray2[1] - dArray2[0]) * (dArray[2] - dArray[1]) - (dArray[1] - dArray[0]) * (dArray2[2] - dArray2[1])) < 0.0) {
                    return null;
                }
            }
            polygon.addPoint((int)((double)(this.w_ / 2 + this.panX_) + this.sx2D_ * point3D.X() + 0.5), (int)((double)(this.h_ / 2 - this.panY_) - this.sy2D_ * point3D.Y() + 0.5));
            ++n2;
        }
        return polygon;
    }

    public boolean isInPolygon(Polygon3D polygon3D, int n, int n2) {
        Polygon polygon = this.makeAWTPolygon(polygon3D);
        if (polygon == null) {
            return false;
        }
        return polygon.contains(n, n2);
    }

    public void drawPolygon(Polygon3D polygon3D, Graphics graphics) {
        Polygon polygon = this.makeAWTPolygon(polygon3D);
        if (polygon == null) {
            return;
        }
        graphics.setColor(polygon3D.getColor());
        graphics.fillPolygon(polygon);
        if (polygon3D.getOutlines()) {
            graphics.setColor(Color.black);
        }
        graphics.drawPolygon(polygon);
    }

    public void paint(Graphics graphics) {
        this.paintFrame(graphics);
    }

    public synchronized void paintFrame(Graphics graphics) {
        this.getSize();
        graphics.drawRect(0, 0, this.w_ - 1, this.h_ - 1);
        int n = 0;
        while (n < this.drawCount_) {
            this.drawables_[n].drawOn(this, graphics);
            ++n;
        }
        if (this.border3D_ > 0) {
            graphics.setColor(Color.gray);
            int n2 = 0;
            while (n2 < this.border3D_ - 1) {
                graphics.draw3DRect(n2, n2, this.w_ - 2 * n2 - 1, this.h_ - 2 * n2 - 1, false);
                ++n2;
            }
            graphics.setColor(Color.black);
            graphics.drawRect(this.border3D_ - 1, this.border3D_ - 1, this.w_ - 2 * (this.border3D_ - 1) - 1, this.h_ - 2 * (this.border3D_ - 1) - 1);
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize_;
    }

    public void set2DXScale(double d) {
        this.sx2D_ = d;
    }

    public void set2DYScale(double d) {
        this.sy2D_ = d;
    }

    public void set3DBorder(int n) {
        if (n > 0) {
            this.border3D_ = n;
            return;
        }
        this.border3D_ = 0;
    }

    public Point3D project(Point3D point3D) {
        Point3D point3D2 = this.per.transform(this.s.transform(point3D));
        return new Point3D((double)(this.w_ / 2 + this.panX_) + point3D2.X() * this.sx2D_ + 0.5, (double)(this.h_ / 2 - this.panY_) - point3D2.Y() * this.sy2D_ + 0.5, 0.0);
    }

    public void pan(int n, int n2) {
        this.panX_ = n;
        this.panY_ = n2;
    }

    public void setAspectPreservation(boolean bl) {
        this.aspectPreservation_ = bl;
    }

    public void setBoundingWindow(Point3D[] point3DArray, Insets insets) {
        this.setBoundingWindow(point3DArray, insets.left, insets.top, this.getSize().width - insets.left - insets.right, this.getSize().height - insets.top - insets.bottom);
    }

    public void setBoundingWindow(Point3D[] point3DArray, int n, int n2, int n3, int n4) {
        double d;
        double d2;
        this.panY_ = 0;
        this.panX_ = 0;
        this.sy2D_ = 1.0;
        this.sx2D_ = 1.0;
        Point3D point3D = this.per.transform(this.s.transform(point3DArray[0]));
        double d3 = d2 = point3D.X();
        double d4 = d = point3D.Y();
        int n5 = 1;
        while (n5 < point3DArray.length) {
            Point3D point3D2 = this.per.transform(this.s.transform(point3DArray[n5]));
            if (point3D2.X() < d3) {
                d3 = point3D2.X();
            }
            if (point3D2.X() > d2) {
                d2 = point3D2.X();
            }
            if (point3D2.Y() < d4) {
                d4 = point3D2.Y();
            }
            if (point3D2.Y() > d) {
                d = point3D2.Y();
            }
            ++n5;
        }
        double d5 = (double)n3 / (d2 - d3);
        double d6 = (double)n4 / (d - d4);
        if (this.aspectPreservation_) {
            if (d5 < d6) {
                this.sx2D_ *= d5;
                this.sy2D_ *= d5;
            } else {
                this.sx2D_ *= d6;
                this.sy2D_ *= d6;
            }
        } else {
            this.sx2D_ *= d5;
            this.sy2D_ *= d6;
        }
        double d7 = (double)(this.w_ / 2) + (d3 + d2) / 2.0 * this.sx2D_;
        double d8 = (double)n + (double)n3 / 2.0;
        double d9 = d8 - d7;
        this.panX_ = (int)Math.round(d9 + 0.5);
        double d10 = d4 * this.sy2D_;
        double d11 = d * this.sy2D_;
        double d12 = (double)(this.h_ / 2) - (d4 + d) / 2.0 * this.sy2D_;
        double d13 = (double)n2 + (double)n4 / 2.0;
        double d14 = d13 - d12;
        this.panY_ = (int)Math.round(-d14 + 0.5);
        this.sWidth_ = (double)this.w_ / this.sx2D_;
        this.sHeight_ = (double)this.h_ / this.sy2D_;
    }
}

